<?php

require_once(INCLUDE_DIR . 'class.topic.php');
require_once(INCLUDE_DIR . 'class.dynamic_forms.php');
require_once(INCLUDE_DIR . 'class.forms.php');

class DynamicFormsAjaxAPI extends AjaxController {
    function getForm($form_id) {
        $form = DynamicForm::lookup($form_id);
        if (!$form) return;

        foreach ($form->getFields() as $field) {
            $field->render();
        }
    }

    function getFormsForHelpTopic($topic_id, $client=false) {
        if (!$_SERVER['HTTP_REFERER'])
            Http::response(403, 'Forbidden.');

        if (!($topic = Topic::lookup($topic_id)))
            Http::response(404, 'No such help topic');

        if ($_GET || isset($_SESSION[':form-data'])) {
            if (!is_array($_SESSION[':form-data']))
                $_SESSION[':form-data'] = array();
            $_SESSION[':form-data'] = array_merge($_SESSION[':form-data'],
                    Format::htmlchars($_GET));
        }

        foreach ($topic->getForms() as $form) {
            if (!$form->hasAnyVisibleFields())
                continue;
            ob_start();
            $form->getForm($_SESSION[':form-data'])->render(array(
                'staff' => !$client,
                'mode' => 'create'));
            $html .= ob_get_clean();
            ob_start();
            print $form->getMedia();
            $media .= ob_get_clean();
        }
        return $this->encode(array(
            'media' => $media,
            'html' => $html . " <script type='text/javascript'>

            var mObjectContractNumber, mObjectContractSerie, mObjectContractOwner, mIndex, mIndexSolicitud, mObjectContractPromotor, mObjectContractPromotorCod, mObjectContractPromotorOfic;

            if ( $('#dynamic-form').find('h3').text() != '' ) {
                

                console.log( 'h3asdasdasd: ' + $('#dynamic-form').find('h3').text());

                //window.location = 'http://192.168.0.16:8021/panteones/contracts/getExcelReportO';

                if ( $('#dynamic-form').find('h3').text().includes('Asistencia Social') ) {

                    $('#dynamic-form').find('label').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        console.log('$( this ).text() = ' + $( this ).text());

                        if ( $( this ).text().includes('    Contrato') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }

                    });

                    $('#dynamic-form').append( \"<tr><td><label style='display: none;'></label></td><td><label id='errorTicketRepeated' style='display: none;font-weight: bold;color: red;'>¡Ya existe un ticket con el mismo contrato!</label></td></tr>\" );

                    $('#dynamic-form').find('input').each(function( index ) {

                        if ( index == 0 ) {
                            mObjectContractSerie = $(this);
                        }

                        if ( index == 2 ) {
                            mObjectContractOwner = $(this);
                        }

                        if ( index == 3 ) {
                            mObjectContractPromotor = $(this);
                            mObjectContractPromotor.css({width: '250px'});
                            //mObjectContractPromotor.prop( 'disabled', true );
                        }

                        if ( index == 4 ) {
                            mObjectContractPromotorCod = $(this);
                            //mObjectContractPromotorCod.prop( 'disabled', true );
                        }

                        if ( index == 5 ) {
                            mObjectContractPromotorOfic = $(this);
                            //mObjectContractPromotorOfic.prop( 'disabled', true );
                        }

                        if ( index == mIndex ) {
                            console.log('OBJETO ENCONTRADO');
                        
                            console.log( index + ': ' + $( this ).val());
                            console.log( 'attr.id: ' + $( this ).attr('id'));

                            /////////////////////////
                            $( this ).focus(function() {
                                console.log('in');
                            }).blur(function() {
                                console.log('out...');

                                var params = {serie:mObjectContractSerie.val(), no_contrato:$(this).val() };
                                
                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getContract',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {

                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);
                                                           //$('#_b042f4059f240c23').val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                           mObjectContractOwner.val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                      }
                                                      else
                                                      {
                                                            mObjectContractOwner.val( result.error );
                                                      }
                                                }
                                });

                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getPromotorInfo',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {

                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);

                                                            mObjectContractPromotor.val( result.result[0].Nombre );
                                                            mObjectContractPromotorCod.val( result.result[0].Codigo );
                                                            mObjectContractPromotorOfic.val( result.result[0].Oficina );
                                                      }
                                                      else
                                                      {
                                                            //mObjectContractOwner.val( result.error );
                                                        console.log('error al encontrat promotor');
                                                      }
                                                }
                                });

                                $.ajax({type:'GET',
                                    url:'http://192.168.0.16:8021/panteones/contracts/checkIfThereISAnyOpenTicketAlready',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                            if(result.error == null)
                                            {
                                                console.log('checkIfThereISAnyOpenTicketAlready = ' + result.result);
                                                console.log('result.error == null: ' + result.result);
                                                if ( result.result ) {
                                                    $('#errorTicketRepeated').css({ display: 'block' });
                                                } else {
                                                    $('#errorTicketRepeated').css({ display: 'none' });
                                                }
                                                
                                            }
                                            else
                                            {
                                                mObjectContractOwner.val( result.error );
                                            }
                                    }
                                });
                                

                                console.log('finish out - B');

                            });
                            /////////////////////////
                        } else {
                            console.log('NO ES OBJETO');
                        }


                    });
                } else if ( $('#dynamic-form').find('h3').text().includes('Cobranza') ) {

                    $('#dynamic-form').find('label').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        if ( $( this ).text().includes('Folio Contrato') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }
                    });

                    $('#dynamic-form').find('input').each(function( index ) {

                        if ( index == 0 ) {
                            mObjectContractSerie = $(this);
                        }

                        if ( index == 2 ) {
                            mObjectContractOwner = $(this);
                        }

                        if ( index == mIndex ) {
                            console.log('OBJETO ENCONTRADO');
                        
                            console.log( index + ': ' + $( this ).val());
                            console.log( 'attr.id: ' + $( this ).attr('id'));

                            /////////////////////////
                            $( this ).focus(function() {
                                console.log('in');
                            }).blur(function() {
                                console.log('out...');

                                var params = {serie:mObjectContractSerie.val(), no_contrato:$(this).val() };
                                
                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getContract',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {
                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);
                                                           //$('#_b042f4059f240c23').val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                           mObjectContractOwner.val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                      }
                                                      else
                                                      {
                                                            //$('#_b042f4059f240c23').val( result.error );
                                                            mObjectContractOwner.val( result.error );
                                                      }
                                                }
                                });
                                

                                console.log('finish out - 3');

                            });
                            /////////////////////////
                        } else {
                            console.log('NO ES OBJETO');
                        }


                    });
                } else if ( $('#dynamic-form').find('h3').text().includes('MKT y Diseño') ) {

                    console.log('MKT y Diseño FOUND - 2');

                    $('#dynamic-form').find('label').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        if ( $( this ).text().includes('    Proyecto') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }
                    });

                    console.log('setting onchange...');
                    $('#dynamic-form').find('select').first().on('change', function() {
                      //alert( this.value );
                      console.log('selected:' + this.value);

                      if ( this.value <= 206 && this.value != 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');
                      } else if ( this.value == 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Nombre de la empresa:</strong>&nbsp;<br><br><strong>Giro:</strong>&nbsp;<br><br><strong>Concepto:</strong> <br>​<br><strong>Target:</strong> <br><br></blockquote>');
                      } else if ( this.value == 207 || this.value == 209 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Concepto (seleccionar con una X):</strong><br>&nbsp;&nbsp;Inauguraciones _____<br>&nbsp;&nbsp;Instalaciones _____<br>&nbsp;&nbsp;Personas _____<br>&nbsp;&nbsp;Otro _____&nbsp;<br><br><strong>Fecha:</strong>&nbsp;<br><br><strong>Hora:</strong> <br>​<br><strong>Dirección del lugar:</strong> <br><br></blockquote>');
                      } else if ( this.value >= 210 && this.value <= 212 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tema de la campaña:<br>​</strong><br><strong>Descripción del contenido (poner aquí el texto que desea que aparezca: fechas, contenido textual, dirección, etc.):</strong>&nbsp;<br><br><strong>Público al que está dirigido:</strong> <br><br></blockquote>');
                      } else {
                            $('.redactor-in').first().html('');
                      }


                    });
                }
            } else if ( $('#dynamic-form').find('strong').text() != '' ) {

                console.log( 'aastrong: ' + $('#dynamic-form').find('strong').text());

                //window.location = 'http://192.168.0.16:8021/panteones/contracts/getExcelReportO';

                if ( $('#dynamic-form').find('strong').text().includes('Asistencia Social') ) {

                    $('#dynamic-form').find('td').filter('.multi-line').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        console.log('$( this ).text() = ' + $( this ).text());

                        if ( $( this ).text().includes('    Contrato') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }

                    });

                    $('#dynamic-form').append( \"<tr><td><label style='display: none;'></label></td><td><label id='errorTicketRepeated' style='display: none;font-weight: bold;color: red;'>¡Ya existe un ticket con el mismo contrato!</label></td></tr>\" );

                    $('#dynamic-form').find('input').each(function( index ) {

                        if ( index == 0 ) {
                            mObjectContractSerie = $(this);
                        }

                        if ( index == 2 ) {
                            mObjectContractOwner = $(this);
                        }

                        if ( index == 3 ) {
                            mObjectContractPromotor = $(this);
                            mObjectContractPromotor.css({width: '250px'});
                            //mObjectContractPromotor.prop( 'disabled', true );
                        }

                        if ( index == 4 ) {
                            mObjectContractPromotorCod = $(this);
                            //mObjectContractPromotorCod.prop( 'disabled', true );
                        }

                        if ( index == 5 ) {
                            mObjectContractPromotorOfic = $(this);
                            //mObjectContractPromotorOfic.prop( 'disabled', true );
                        }

                        if ( index == mIndex ) {
                            console.log('OBJETO ENCONTRADO');
                        
                            console.log( index + ': ' + $( this ).val());
                            console.log( 'attr.id: ' + $( this ).attr('id'));

                            /////////////////////////
                            $( this ).focus(function() {
                                console.log('in');
                            }).blur(function() {
                                console.log('out...');

                                var params = {serie:mObjectContractSerie.val(), no_contrato:$(this).val() };
                                
                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getContract',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {

                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);
                                                           //$('#_b042f4059f240c23').val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                           mObjectContractOwner.val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                      }
                                                      else
                                                      {
                                                            mObjectContractOwner.val( result.error );
                                                      }
                                                }
                                });

                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getPromotorInfo',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {

                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);

                                                            mObjectContractPromotor.val( result.result[0].Nombre );
                                                            mObjectContractPromotorCod.val( result.result[0].Codigo );
                                                            mObjectContractPromotorOfic.val( result.result[0].Oficina );
                                                      }
                                                      else
                                                      {
                                                            //mObjectContractOwner.val( result.error );
                                                        console.log('error al encontrat promotor');
                                                      }
                                                }
                                });

                                $.ajax({type:'GET',
                                    url:'http://192.168.0.16:8021/panteones/contracts/checkIfThereISAnyOpenTicketAlready',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                            if(result.error == null)
                                            {
                                                console.log('checkIfThereISAnyOpenTicketAlready = ' + result.result);
                                                console.log('result.error == null: ' + result.result);
                                                if ( result.result ) {
                                                    $('#errorTicketRepeated').css({ display: 'block' });
                                                } else {
                                                    $('#errorTicketRepeated').css({ display: 'none' });
                                                }
                                                
                                            }
                                            else
                                            {
                                                mObjectContractOwner.val( result.error );
                                            }
                                    }
                                });
                                

                                console.log('finish out - 2');

                            });
                            /////////////////////////
                        } else {
                            console.log('NO ES OBJETO');

                            console.log( index + ': ' + $( this ).val());
                            console.log( 'attr.id: ' + $( this ).attr('id'));
                        }


                    });
                } else if ( $('#dynamic-form').find('strong').text().includes('Cobranza') ) {

                    $('#dynamic-form').find('td').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        if ( $( this ).text().includes('Folio Contrato') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }
                    });

                    $('#dynamic-form').find('input').each(function( index ) {

                        if ( index == 0 ) {
                            mObjectContractSerie = $(this);
                        }

                        if ( index == 2 ) {
                            mObjectContractOwner = $(this);
                        }

                        if ( index == mIndex ) {
                            console.log('OBJETO ENCONTRADO');
                        
                            console.log( index + ': ' + $( this ).val());
                            console.log( 'attr.id: ' + $( this ).attr('id'));

                            /////////////////////////
                            $( this ).focus(function() {
                                console.log('in');
                            }).blur(function() {
                                console.log('out...');

                                var params = {serie:mObjectContractSerie.val(), no_contrato:$(this).val() };
                                
                                $.ajax({type:'GET',
                                    url:'http://192.168.0.25:8021/ecobro/controlcartera/getContract',
                                    dataType: 'jsonp',
                                    ontentType :'application/x-www-form-urlencoded; charset=UTF-8',
                                    data:params,
                                    success:function(result,status){
                                                      if(result.error == null)
                                                      {
                                                           console.log('result.error == null: ' + result.result);
                                                           console.log('nombre = ' + result.result[0].nombre);
                                                           //$('#_b042f4059f240c23').val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                           mObjectContractOwner.val( result.result[0].nombre + ' ' + result.result[0].apellido_pat + ' ' + result.result[0].apellido_mat );
                                                      }
                                                      else
                                                      {
                                                            //$('#_b042f4059f240c23').val( result.error );
                                                            mObjectContractOwner.val( result.error );
                                                      }
                                                }
                                });
                                

                                console.log('finish out - 1');

                            });
                            /////////////////////////
                        } else {
                            console.log('NO ES OBJETO');
                        }


                    });
                } else if ( $('#dynamic-form').find('strong').text().includes('MKT y Diseño') ) {

                    /*console.log('MKT y Diseño FOUND');

                    $('#dynamic-form').find('td').filter('.multi-line').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        console.log('$( this ).text() = ' + $( this ).text());

                        if ( $( this ).text().includes('    Proyecto') ) {
                            console.log('AQUI');

                            mIndex = index;
                        } else {
                            console.log('else');
                        }

                    });

                    //$('#dynamic-form').append( \"<tr><td><label style='display: none;'></label></td><td><label id='errorTicketRepeated' style='display: none;font-weight: bold;color: red;'>¡Ya existe un ticket con el mismo contrato!</label></td></tr>\" );

                    setTimeout(
                              function() 
                              {
                              console.log('setting onchange...');
                                $('#dynamic-form').find('select').first().on('change', function() {
                                  alert( this.value );
                                  console.log('lasdasdlalalalalallalal');
                                });
                              }, 1000);*/

                    console.log('MKT y Diseño FOUND - 2');

                    $('#dynamic-form').find('label').each(function( index ) {

                        console.log( index + ': ' + $( this ).text());
                        console.log( 'attr.id: ' + $( this ).attr('id'));

                        if ( $( this ).text().includes('    Proyecto') ) {
                            console.log('AQUI');

                            mIndex = index;
                        }
                    });

                    console.log('setting onchange...');
                    /*$('#dynamic-form').find('select').first().on('change', function() {
                      //alert( this.value );
                      console.log('selected:' + this.value);

                      if ( this.value <= 206 && this.value != 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');
                      } else if ( this.value == 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Nombre de la empresa:</strong>&nbsp;<br><br><strong>Giro:</strong>&nbsp;<br><br><strong>Concepto:</strong> <br>​<br><strong>Target:</strong> <br><br></blockquote>');
                      } else if ( this.value == 207 || this.value == 209 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Concepto (seleccionar con una X):</strong><br>&nbsp;&nbsp;Inauguraciones _____<br>&nbsp;&nbsp;Instalaciones _____<br>&nbsp;&nbsp;Personas _____<br>&nbsp;&nbsp;Otro _____&nbsp;<br><br><strong>Fecha:</strong>&nbsp;<br><br><strong>Hora:</strong> <br>​<br><strong>Dirección del lugar:</strong> <br><br></blockquote>');
                      } else if ( this.value >= 210 && this.value <= 212 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tema de la campaña:<br>​</strong><br><strong>Descripción del contenido (poner aquí el texto que desea que aparezca: fechas, contenido textual, dirección, etc.):</strong>&nbsp;<br><br><strong>Público al que está dirigido:</strong> <br><br></blockquote>');
                      } else {
                            $('.redactor-in').first().html('');
                      }


                    });*/

                    $('#dynamic-form').find('select').first().on('change', function() {
                      //alert( this.value );
                      console.log('new process');
                      console.log('selected:' + this.value);

                      if ( this.value <= 206 && this.value != 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');

                            /*$('.redactor-in').each(function( index ) {
                                if ( index == 1 ) {
                                   $( this ).html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');
                                }
                            });

                            //$('.redactor_box').first().find('textarea').html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');
                            $('.redactor_box').find('textarea').each(function(index){
                                console.log(index);
                                $(this).html('<blockquote><strong>Tamaño deseado:</strong>&nbsp;<br><br><strong>Título de la campaña:</strong>&nbsp;<br><br><strong>Destinatario (seleccionar con una X):</strong> <br>&nbsp;&nbsp;Empleados _____<br>&nbsp;&nbsp;Público en general _____<br><br><strong>Descripción del contenido (poner aqui el texto que desea que aparezca: fechas, contenido textual, dirección, describir fotografía o imagen deseada, etc):</strong> <br><br></blockquote>');
                            });*/

                      } else if ( this.value == 199 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Nombre de la empresa:</strong>&nbsp;<br><br><strong>Giro:</strong>&nbsp;<br><br><strong>Concepto:</strong> <br>​<br><strong>Target:</strong> <br><br></blockquote>');

                            /*$('.redactor-in').each(function( index ) {
                                if ( index == 1 ) {
                                   $( this ).html('<blockquote><strong>Nombre de la empresa:</strong>&nbsp;<br><br><strong>Giro:</strong>&nbsp;<br><br><strong>Concepto:</strong> <br>​<br><strong>Target:</strong> <br><br></blockquote>');
                                }
                            });*/
                      } else if ( this.value == 207 || this.value == 209 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Concepto (seleccionar con una X):</strong><br>&nbsp;&nbsp;Inauguraciones _____<br>&nbsp;&nbsp;Instalaciones _____<br>&nbsp;&nbsp;Personas _____<br>&nbsp;&nbsp;Otro _____&nbsp;<br><br><strong>Fecha:</strong>&nbsp;<br><br><strong>Hora:</strong> <br>​<br><strong>Dirección del lugar:</strong> <br><br></blockquote>');

                            /*$('.redactor-in').each(function( index ) {
                                if ( index == 1 ) {
                                   $( this ).html('<blockquote><strong>Concepto (seleccionar con una X):</strong><br>&nbsp;&nbsp;Inauguraciones _____<br>&nbsp;&nbsp;Instalaciones _____<br>&nbsp;&nbsp;Personas _____<br>&nbsp;&nbsp;Otro _____&nbsp;<br><br><strong>Fecha:</strong>&nbsp;<br><br><strong>Hora:</strong> <br>​<br><strong>Dirección del lugar:</strong> <br><br></blockquote>');
                                }
                            });*/
                      } else if ( this.value >= 210 && this.value <= 212 ) {
                            $('.redactor-in').first().html('<blockquote><strong>Tema de la campaña:<br>​</strong><br><strong>Descripción del contenido (poner aquí el texto que desea que aparezca: fechas, contenido textual, dirección, etc.):</strong>&nbsp;<br><br><strong>Público al que está dirigido:</strong> <br><br></blockquote>');

                            /*$('.redactor-in').each(function( index ) {
                                if ( index == 1 ) {
                                   $( this ).html('<blockquote><strong>Tema de la campaña:<br>​</strong><br><strong>Descripción del contenido (poner aquí el texto que desea que aparezca: fechas, contenido textual, dirección, etc.):</strong>&nbsp;<br><br><strong>Público al que está dirigido:</strong> <br><br></blockquote>');
                                }
                            });*/
                      } else {
                            $('.redactor-in').first().html('');

                            /*$('.redactor-in').each(function( index ) {
                                if ( index == 1 ) {
                                   $( this ).html('');
                                }
                            });*/
                      }


                    });
                    
                }

            }

            </script>",
        ));
    }

    function getClientFormsForHelpTopic($topic_id) {
        return $this->getFormsForHelpTopic($topic_id, true);
    }

    function getFieldConfiguration($field_id) {
        $field = DynamicFormField::lookup($field_id);
        include(STAFFINC_DIR . 'templates/dynamic-field-config.tmpl.php');
    }

    function saveFieldConfiguration($field_id) {

        if (!($field = DynamicFormField::lookup($field_id)))
            Http::response(404, 'No such field');

        $DFF = 'DynamicFormField';

        // Capture flags which should remain unchanged
        $p_mask = $DFF::MASK_MASK_ALL;
        if ($field->isPrivacyForced()) {
            $p_mask |= $DFF::FLAG_CLIENT_VIEW | $DFF::FLAG_AGENT_VIEW;
        }
        if ($field->isRequirementForced()) {
            $p_mask |= $DFF::FLAG_CLIENT_REQUIRED | $DFF::FLAG_AGENT_REQUIRED;
        }
        if ($field->hasFlag($DFF::FLAG_MASK_DISABLE)) {
            $p_mask |= $DFF::FLAG_ENABLED;
        }

        // Capture current state of immutable flags
        $preserve = $field->flags & $p_mask;

        // Set admin-configured flag states
        $flags = array_reduce($_POST['flags'],
            function($a, $b) { return $a | $b; }, 0);
        $field->flags = $flags | $preserve;

        if ($field->setConfiguration($_POST)) {
            $field->save();
            Http::response(201, 'Field successfully updated');
        }

        include STAFFINC_DIR . 'templates/dynamic-field-config.tmpl.php';
    }

    function deleteAnswer($entry_id, $field_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');

        $ent = DynamicFormEntryAnswer::lookup(array(
            'entry_id'=>$entry_id, 'field_id'=>$field_id));
        if (!$ent)
            Http::response(404, 'Answer not found');

        $ent->delete();
    }


    function getListItem($list_id, $item_id) {

        $list = DynamicList::lookup($list_id);
        if (!$list)
            Http::response(404, 'No such list item');

        $list = CustomListHandler::forList($list);
        if (!($item = $list->getItem( (int) $item_id)))
            Http::response(404, 'No such list item');

        $action = "#list/{$list->getId()}/item/{$item->getId()}/update";
        $item_form = $list->getListItemBasicForm($item->ht, $item);

        include(STAFFINC_DIR . 'templates/list-item-properties.tmpl.php');
    }

    function getListItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');

        if (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');

        $pjax_container = '#items';
        include(STAFFINC_DIR . 'templates/list-items.tmpl.php');
    }

    function previewListItem($list_id, $item_id) {

        $list = DynamicList::lookup($list_id);
        if (!$list)
            Http::response(404, 'No such list item');

        $list = CustomListHandler::forList($list);
        if (!($item = $list->getItem( (int) $item_id)))
            Http::response(404, 'No such list item');

        $form = $list->getListItemBasicForm($item->ht, $item);
        include(STAFFINC_DIR . 'templates/list-item-preview.tmpl.php');
    }

    function saveListItem($list_id, $item_id) {
        global $thisstaff;

        $errors = array();

        if (!$thisstaff)
            Http::response(403, 'Login required');

        $list = DynamicList::lookup($list_id);
        if (!$list)
            Http::response(404, 'No such list item');

        $list = CustomListHandler::forList($list);
        if (!$list || !($item = $list->getItem( (int) $item_id)))
            Http::response(404, 'No such list item');

        $item_form = $list->getListItemBasicForm($_POST, $item);

        if ($valid = $item_form->isValid()) {
            if ($_item = DynamicListItem::lookup(array(
                'list_id' => $list->getId(), 'value'=>$item->getValue()))
            ) {
                if ($_item && $_item->id != $item->id)
                    $item_form->getField('value')->addError(
                        __('Value already in use'));
            }
            if ($item_form->isValid()) {
                // Update basic information
                $basic = $item_form->getClean();
                $item->update([
                    'name' =>   $basic['name'],
                    'value' =>  $basic['value'],
                    'abbrev' =>  $basic['extra'],
                ], $errors);
            }
        }

        // Context
        $action = "#list/{$list->getId()}/item/{$item->getId()}/update";
        $icon = ($list->get('sort_mode') == 'SortCol')
            ? '<i class="icon-sort"></i>&nbsp;' : '';

        if (!$valid || !$item->setConfiguration($_POST)) {
            include STAFFINC_DIR . 'templates/list-item-properties.tmpl.php';
            return;
        }
        else {
            $item->save();
        }

        Http::response(201, $this->encode(array(
            'id' => $item->getId(),
            'row' => $this->_renderListItem($item, $list),
            'success' => true,
        )));
    }

    function _renderListItem($item, $list=false) {
        $list = $list ?: $item->getList();

        // Send the whole row back
        $prop_fields = $list->getSummaryFields();
        $icon = ($list->get('sort_mode') == 'SortCol')
            ? '<i class="icon-sort"></i>&nbsp;' : '';
        ob_start();
        $item->_config = null;
        include STAFFINC_DIR . 'templates/list-item-row.tmpl.php';
        return ob_get_clean();
    }

    function searchListItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');
        elseif (!($q = $_GET['q']))
            Http::response(400, '"q" query arg is required');

        $list = CustomListHandler::forList($list);
        $items = $list->search($q);

        $results = array();
        foreach ($items as $I) {
            $display = $I->getValue();
            if (isset($I->extra))
              $display .= " ({$I->extra})";
            $results[] = array(
                'value' => $I->getValue(),
                'display' => $display,
                'id' => $I->id,
                'list_id' => $list->getId(),
            );
        }
        return $this->encode($results);
    }

    function addListItem($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');

        $list = CustomListHandler::forList($list);
        $action = "#list/{$list->getId()}/item/add";
        $item_form = $list->getListItemBasicForm($_POST ?: null);
        $errors = array();

        if ($_POST && ($valid = $item_form->isValid())) {
            $data = $item_form->getClean();
            if ($list->isItemUnique($data)) {
                $item = $list->addItem($data, $errors);
                if ($item->setConfiguration($_POST, $errors)) {
                    Http::response(201, $this->encode(array(
                        'success' => true,
                        'row' => $this->_renderListItem($item, $list)
                    )));
                }
            }
            else {
                $item_form->getField('value')->addError(
                    __('Value already in use'));
            }
        }

        include(STAFFINC_DIR . 'templates/list-item-properties.tmpl.php');
    }

    function importListItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');

        $list = CustomListHandler::forList($list);
        $info = array(
            'title' => sprintf('%s &mdash; %s',
                $list->getName(), __('Import Items')),
            'action' => "#list/{$list_id}/import",
            'upload_url' => "lists.php?id={$list_id}&amp;do=import-items",
        );

        if ($_POST) {
            $status = $list->importFromPost($_FILES['import'] ?: $_POST['pasted']);
            if ($status && is_numeric($status))
                Http::response(201, $this->encode( array('success' => true, 'count' => $status)));

            $info['error'] = $status;
            $info['pasted'] = Format::htmlchars($_POST['pasted']);
        }

        include(STAFFINC_DIR . 'templates/list-import.tmpl.php');
    }

    function disableItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');
        elseif (!$_POST['ids'])
            Http::response(422, 'Send `ids` parameter');

        $list = CustomListHandler::forList($list);
        foreach ($_POST['ids'] as $id) {
            if ($item = $list->getItem( (int) $id)) {
                $item->disable();
                $item->save();
            }
            else {
                Http::response(404, 'No such list item');
            }
        }
        Http::response(200, $this->encode(array('success' => true)));
    }

    function undisableItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');
        elseif (!$_POST['ids'])
            Http::response(422, 'Send `ids` parameter');

        $list = CustomListHandler::forList($list);
        foreach ($_POST['ids'] as $id) {
            if ($item = $list->getItem( (int) $id)) {
                $item->enable();
                $item->save();
            }
            else {
                Http::response(404, 'No such list item');
            }
        }
        Http::response(200, $this->encode(array('success' => true)));
    }

    function deleteItems($list_id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!($list = DynamicList::lookup($list_id)))
            Http::response(404, 'No such list');
        elseif (!$_POST['ids'])
            Http::response(422, 'Send `ids` parameter');

        foreach ($_POST['ids'] as $id) {
            if ($item = $list->getItem( (int) $id)) {
                $item->delete();
            }
            else {
                Http::response(404, 'No such list item');
            }
        }
        Http::response(200, $this->encode(array('success' => true)));
    }

    function upload($id) {
        if (!$field = DynamicFormField::lookup($id))
            Http::response(400, 'No such field');

        $impl = $field->getImpl();
        if (!$impl instanceof FileUploadField)
            Http::response(400, 'Upload to a non file-field');

        return JsonDataEncoder::encode(
            array('id'=>$impl->ajaxUpload())
        );
    }

    function attach() {
        global $thisstaff;

        $config = DynamicFormField::objects()
            ->filter(array('type__contains'=>'thread'))
            ->first()->getConfiguration();
        $field = new FileUploadField();
        $field->_config = $config;
        return JsonDataEncoder::encode(
            array('id'=>$field->ajaxUpload($thisstaff ? true : false))
        );
    }

    function getAllFields($id) {
        global $thisstaff;

        if (!$thisstaff)
            Http::response(403, 'Login required');
        elseif (!$form = DynamicForm::lookup($id))
            Http::response(400, 'No such form');

        // XXX: Fetch the form via the list!
        ob_start();
        include STAFFINC_DIR . 'templates/dynamic-form-fields-view.tmpl.php';
        $html = ob_get_clean();

        return $this->encode(array(
            'success'=>true,
            'html' => $html,
        ));
    }
}
?>
